<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <title>Ponts du monde</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" media="screen and (max-width: 500px)" href="style2.css" type="text/css" />
    <link rel="stylesheet" media="screen and (min-width: 1020px)" href="style1.css" type="text/css" />
  </head>
  <body>
    <h1>Ponts du monde</h1>
    <p>Ce site présente les pont les plus remarquables dans le monde. <hr/> Il est destiné à s'agrandir en fonction de mon temps et de mes connaissances en programmation de site.</p>
    <h2>Liste des ponts</h2>

<?php
  // Créer un tableau vide pour la liste
  $liste = array();

  // Lecture de toutes les pages concernant les ponts
  $site = opendir(".");
  while (($fichier = readdir($site)) != false) {
    $info = pathinfo($fichier);
    if ($info["extension"] == "html") {
      if ($info["basename"] != "index.html") {
        
        // Récupération du nom du pont et ajout de la page et du nom à la liste
        $page = new SimpleXMLElement('./' . $fichier, NULL, TRUE);
        $pont = $page->body->h2;
        $liste[$info["basename"]] = $pont;
      }
    }
  }

  // Tri alphabétique et affichage de la liste
  asort($liste);
  echo "\t\tLa collection possède " . count($liste) . " ponts :\n";
  echo "\t\t<ul>\n";
  foreach ($liste as $key => $value)
    printf("\t\t\t<li><a href='%s'>%s</a></li>\n", $key, $value);
  echo "\t\t</ul>\n";
?>

  </body>
</html> 